\ makeqasm.f: build a version of qasm

MARKER toss

\ Uncomment one of these lines:
 -1 constant SwiftForth   0 constant standalone    0 constant Win32Forth
\ -1 constant SwiftForth  -1 constant standalone    0 constant Win32Forth
\  0 constant SwiftForth   0 constant standalone   -1 constant Win32Forth

SwiftForth 0= [IF]
   : -origin ( a - a ) ;     : +origin ( a - a ) ;
[THEN]

: -ORDER     ( - )  GET-ORDER  1- NIP  SET-ORDER ;
: +ORDER ( wid - )  >R GET-ORDER  1+ R> SWAP  SET-ORDER ;
: SWAP-CURRENT ( wid - wid' )  GET-CURRENT  SWAP SET-CURRENT ;

: CURRENT-ORDER= ( 'word' - )  \ save the current & search-order wordlists
   CREATE GET-CURRENT GET-ORDER ( wid ... n ) DUP ,  -1 DO -origin , LOOP
 DOES> ( ia - )  \ restore the current and search-order wordlists
   ( ia ) DUP @ 1+ CELLS OVER +
( ia a' ) DO I @ +origin -1 CELLS +LOOP -origin SET-ORDER SET-CURRENT
;
CURRENT-ORDER= HOST     \ used later to restore the host's active wordlists

INCLUDE ..\..\forth\meta.f          \ generic metacompiler

HOST +META DEFINITIONS  \ add the rest to the metacompiler

INCLUDE qasm.f                      \ chip-specific assembler & disassembler

INCLUDE ..\..\forth\tools.f         \ generic dump, words, see, tofile

HOST                    \ restore host wordlists

SwiftForth standalone AND [IF] \ =============================================

   +META  HOST  STARTER image[   PROGRAM qasm

[THEN] \ =====================================================================

CR .( MAKEQASM is finished. )
